package gov.va.vinci.dart.db;

import gov.va.vinci.dart.biz.RequestSummary;
import gov.va.vinci.dart.db.impl.RequestSummaryForGroupBuilder;
import gov.va.vinci.dart.db.util.CallableStatementDAO;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Retrieves all requests for the specified review group.  Used for review groups other than NDS.
 */
public class AllRequestsByGroupDAO extends CallableStatementDAO<RequestSummary> {
	private String groupName;
	RequestSummaryForGroupBuilder builder = new RequestSummaryForGroupBuilder();	//has an extra reviewID field
	
	public AllRequestsByGroupDAO(final String groupName) {
		this.groupName = groupName;
	}
	
	public String getQueryText() {
		return "{call [ws].[GetDARTDashboardRequestsByGroup](?)}";   //get the reviewable requests for this intermediate review group (review group other than NDS)
	}
	
	public void populateParameters(final CallableStatement cstmt) throws SQLException {
		
		if( groupName == null )
			groupName = "";
		
		cstmt.setString(1, groupName.trim());
	}
	
	public RequestSummary buildResult(final ResultSet rs) throws SQLException {        
        return builder.build(rs);
	}
}
